%------------------------------------------------------------------------------
% File     : DAT334^23 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Data Structures
% Problem  : Database querying
% Version  : [BP13] axioms.
% English  : 

% Refs     : [Rei92] Reiter (1992), What Should a Database Know?
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : APM009+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.11 v9.1.0, 0.12 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0
% Syntax   : Number of formulae    :   37 (  12 unt;  21 typ;  10 def)
%            Number of atoms       :   46 (  10 equ;   0 cnn)
%            Maximal formula atoms :   10 (   2 avg)
%            Number of connectives :   75 (   1   ~;   1   |;   5   &;  62   @)
%                                         (   1 <=>;   5  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   3 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   62 (  62   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   21 (  20 usr;   7 con; 0-3 aty)
%            Number of variables   :   38 (  25   ^;  10   !;   3   ?;  38   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $decreasing,
%            $modalities == $modal_system_S5].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_reflexive,axiom,
    ! [W: mworld] : ( mrel @ W @ W ) ).

thf(mrel_euclidean,axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ W @ U )
        & ( mrel @ W @ V ) )
     => ( mrel @ U @ V ) ) ).

thf(eiw_di_type,type,
    eiw_di: $i > mworld > $o ).

thf(eiw_di_nonempty,axiom,
    ! [W: mworld] :
    ? [X: $i] : ( eiw_di @ X @ W ) ).

thf(eiw_di_decr,axiom,
    ! [W: mworld,V: mworld,X: $i] :
      ( ( ( eiw_di @ X @ W )
        & ( mrel @ V @ W ) )
     => ( eiw_di @ X @ V ) ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] :
          ( ( eiw_di @ X @ W )
         => ( A @ X @ W ) ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] :
          ( ( eiw_di @ X @ W )
          & ( A @ X @ W ) ) ) ) ).

thf(cs_decl,type,
    cs: $i ).

thf(sue_decl,type,
    sue: $i ).

thf(mary_decl,type,
    mary: $i ).

thf(john_decl,type,
    john: $i ).

thf(math_decl,type,
    math: $i ).

thf(psych_decl,type,
    psych: $i ).

thf(teach_decl,type,
    teach: $i > $i > mworld > $o ).

thf(db,axiom,
    ( mlocal
    @ ( mbox
      @ ( mand @ ( teach @ john @ math )
        @ ( mand
          @ ( mexists_di
            @ ^ [X: $i] : ( teach @ X @ cs ) )
          @ ( mand @ ( teach @ mary @ psych ) @ ( teach @ sue @ psych ) ) ) ) ) ) ).

thf(query,conjecture,
    ( mlocal
    @ ( mbox
      @ ( mexists_di
        @ ^ [X: $i] : ( teach @ X @ cs ) ) ) ) ).

%------------------------------------------------------------------------------
